% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{SpatialRNA-class}
\alias{SpatialRNA-class}
\alias{show,SpatialRNA-method}
\title{Spatial transcriptomics data}
\usage{
\S4method{show}{SpatialRNA}(object)
}
\arguments{
\item{object}{SpatialRNA object}
}
\description{
A class representing spatial transcriptomics data, where gene expression is
measured at fixed locations called "pixels" (also known as "spots" or
"beads"). RCTD estimates the proportions of different cell types on each
pixel.
}
\section{Slots}{

\describe{
\item{\code{coords}}{data frame (or matrix) containing x and y coordinates for each
pixel (identified by barcode)}

\item{\code{counts}}{sparse matrix of gene expression counts, with genes as rows and
pixels as columns (named by pixel barcode)}

\item{\code{nUMI}}{numeric vector of total UMI counts per pixel (identified by
barcode)}
}}

\examples{
data(rctdSim)

# Create SpatialRNA object
spatial_rna <- createSpatialRNA(
    as.data.frame(rctdSim$spatial_rna_coords),
    rctdSim$spatial_rna_counts
)

}
\keyword{internal}
