% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_clusters.R
\name{simulate_clusters}
\alias{simulate_clusters}
\title{Simulate clusters}
\usage{
simulate_clusters(
  bg_sample = bg1,
  n_clusters = 2,
  bg_type = "Others",
  cluster_properties = list(C1 = list(name_of_cluster_cell = "Tumour", size = 300, shape
    = "Oval", centre_loc = data.frame(x = 500, y = 500), infiltration_types =
    c("Immune1", "Others"), infiltration_proportions = c(0.1, 0.05)), C2 =
    list(name_of_cluster_cell = "Immune1", size = 500, shape = "Irregular", centre_loc =
    data.frame(x = 1500, y = 500), infiltration_types = c("Immune2", "Others"),
    infiltration_proportions = c(0.1, 0.05))),
  plot_image = TRUE,
  plot_categories = NULL,
  plot_colours = NULL
)
}
\arguments{
\item{bg_sample}{(OPTIONAL) A data frame or \code{SpatialExperiment} class object
with locations of points representing background cells. Further cell types
will be simulated based on this background sample. The data.frame or the
\code{spatialCoords()} of the SPE object should have colnames including
"Cell.X.Positions" and "Cell.Y.Positions". By default use the internal
\code{\link{bg1}} background image.}

\item{n_clusters}{Numeric. Number of clusters. This must match the
\code{length(cluster_properties)}.}

\item{bg_type}{(OPTIONAL) String. The name of the background cell type if the
background sample does not have a "Cell.Type" column. By default is
"Others".}

\item{cluster_properties}{List of properties of the clusters. See examples
for the format of this arg.}

\item{plot_image}{Boolean. Whether the simulated image is plotted.}

\item{plot_categories}{String Vector specifying the order of the cell
categories to be plotted. Default is NULL - the cell categories under the
"Cell.Type" column would be used for plotting.}

\item{plot_colours}{String Vector specifying the order of the colours that
correspond to the \code{plot_categories} arg. Default is NULL - the predefined
colour vector would be used for plotting.}
}
\value{
A data.frame of the simulated image
}
\description{
Based on an existing background image, simulate clusters of
cells where the same type of cells aggregate. The default values for the
arguments give an example of cluster simulation which enable an automatic
simulation of clusters without the specification of any argument.
}
\examples{
set.seed(610)
cluster_image <- simulate_clusters(bg_sample = bg1,
n_clusters=2, cluster_properties=list(C1=list(name_of_cluster_cell="Tumour",
size=300, shape="Oval", centre_loc=data.frame("x"=500, "y"=500),
infiltration_types=c("Immune1", "Others"), infiltration_proportions=c(0.1, 0.05)),
C2=list(name_of_cluster_cell="Immune1", size=500, shape="Irregular",
centre_loc=data.frame("x"=1500,"y"=500), infiltration_types=c("Immune2", "Others"),
infiltration_proportions=c(0.1, 0.05))))
}
\seealso{
\code{\link{simulate_background_cells}} for all cell simulation,
\code{\link{simulate_mixing}} for mixed background simulation,
\code{\link{simulate_immune_rings}}/\code{\link{simulate_double_rings}} for
immune ring simulation, and \code{\link{simulate_stripes}} for vessel
simulation.

Other simulate pattern functions: 
\code{\link{simulate_background_cells}()},
\code{\link{simulate_double_rings}()},
\code{\link{simulate_immune_rings}()},
\code{\link{simulate_mixing}()},
\code{\link{simulate_stripes}()}
}
\concept{simulate pattern functions}
