% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateMetrics.R
\name{totalShapeMetrics}
\alias{totalShapeMetrics}
\title{Calculate a set of shape metrics of a set of polygons}
\usage{
totalShapeMetrics(sfInput)
}
\arguments{
\item{sfInput}{\code{MULTIPOLYGON} of class sf}
}
\value{
matrix; matrix of shape metrics
}
\description{
Calculate a set of shape metrics of a set of polygons
}
\details{
Calculate a set of shape metrics of a set of polygons.
The function calculates all metrics that are implemented in the function
\code{shapeMetrics()}
}
\examples{
data(sostaSPE)
struct <- reconstructShapeDensityImage(sostaSPE,
    marks = "cellType", imageCol = "imageName",
    imageId = "image1", markSelect = "A", dim = 500
)
totalShapeMetrics(struct)
}
