% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sostaSPE}
\alias{sostaSPE}
\title{Example SpatialExperiment Object with Simulated Tissue Images and Point Patterns}
\format{
A \code{SpatialExperiment} object with the following structure:
\describe{
\item{x}{Numeric; x-coordinate of each point (cell location).}
\item{y}{Numeric; y-coordinate of each point (cell location).}
\item{cell_type}{Factor; Cell type assigned to each point (A, B, or C).}
\item{image_name}{Factor; Identifier for the tissue image (\code{image1}, \code{image2}, or \code{image3}).}
}
}
\usage{
sostaSPE
}
\description{
This dataset contains a simulated \code{SpatialExperiment} object (\code{sostaSPE}) representing
three tissue images, each with a corresponding spatial point pattern. The point patterns
contain different cell types (\code{A}, \code{B}, and \code{C}), distributed according to simulated
tissue structures.
}
\details{
The dataset was generated as follows:
\itemize{
\item Three tissue images were simulated using \code{simulateTissueBlobs()}.
\item Spatial point patterns were created for each tissue using \code{createPointPatternTissue()}.
\item The point pattern data was converted into a \code{SpatialExperiment} object with spatial coordinates.
}
}
\keyword{datasets}
