% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.SPE2df}
\alias{.SPE2df}
\title{Function to convert \code{SpatialExperiment} object to a data frame}
\usage{
.SPE2df(spe, imageCol = NULL, marks = NULL, colNames = FALSE)
}
\arguments{
\item{spe}{SpatialExperiment; a object of class \code{SpatialExperiment}}

\item{imageCol}{character; name of a column in \code{colData} that corresponds to
the image}

\item{marks}{character; name of column in \code{colData} with categorical marks}

\item{colNames}{logical; extract \code{colnames} from \code{SpatialExperiment}}
}
\value{
data.frame with x, y coordinates, image, and categorical mark information
}
\description{
Function to convert \code{SpatialExperiment} object to a data frame
}
\examples{
data(sostaSPE)
.SPE2df(sostaSPE, marks = "cellType", imageCol = "imageName") |> head()
}
