% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateData.R
\name{simulateTissueBlobs}
\alias{simulateTissueBlobs}
\title{Simulate Tissue Blobs}
\usage{
simulateTissueBlobs(size, seedNumber, clumpSize)
}
\arguments{
\item{size}{Integer; The size (width and height) of the simulated tissue image.}

\item{seedNumber}{Integer; The number of random seed points used to generate tissue blobs.}

\item{clumpSize}{Numeric; The standard deviation (sigma) of the Gaussian blur applied to generate tissue clumps.}
}
\value{
A binary matrix representing the simulated tissue structure.
}
\description{
This function generates a simulated tissue-like structure using a Gaussian blur technique.
}
\examples{
tissueImage <- simulateTissueBlobs(128, 100, 7)
image(tissueImage)

}
