% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstructShapePPP.R
\name{shapeIntensityImage}
\alias{shapeIntensityImage}
\title{Intensity plot}
\usage{
shapeIntensityImage(
  spe,
  marks,
  imageCol,
  imageId,
  markSelect,
  bndw = NULL,
  dim = 500
)
}
\arguments{
\item{spe}{SpatialExperiment; a object of class \code{SpatialExperiment}}

\item{marks}{character; name of column in \code{colData} that will correspond to
the \code{ppp} marks}

\item{imageCol}{character; name of a column in \code{colData} that corresponds to
the image}

\item{imageId}{character; image id, must be present in imageCol}

\item{markSelect}{character; name of mark that is to be selected for the
reconstruction}

\item{bndw}{numeric; smoothing bandwidth in the density estimation,
corresponds to the \code{sigma} parameter in the \code{density.ppp} function,
if no value is given the bandwidth is estimated using cross validation with
the \code{bw.diggle} function.}

\item{dim}{numeric; x dimension of the final reconstruction. A lower resolution
speeds up computation but lead to less exact reconstruction. Default = 500}
}
\value{
ggplot object with intensity image and histogram
}
\description{
This function plots the intensity of a point pattern image and displays
a histogram of the intensity values. Note that intensities less than
largest intensity value divided by 250 are not displayed in the histogram.
}
\examples{
data("sostaSPE")
shapeIntensityImage(sostaSPE,
    marks = "cellType", imageCol = "imageName",
    imageId = "image1", markSelect = "A"
)
}
