% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalWeightFunction.R
\name{evalWeightFunction}
\alias{evalWeightFunction}
\title{Evaluate a variance weighting function}
\usage{
evalWeightFunction(wf, newdata)
}
\arguments{
\item{wf}{The weighting function}

\item{newdata}{A data frame with new data}
}
\value{
A vector of weights, so the inverse of predicted variances, unnormalized
}
\description{
Evaluate the variance weighting function to  return unnormalized weights
}
\examples{
data(Yang)
hypYang <- buildHyperFrame(Yang, coordVars = c("x", "y"),
    imageVars = c("day", "root", "section"))
yangPims <- estPis(hypYang, pis = "nn", 
features = getFeatures(hypYang)[12:19], nPointsAll = 5e2)
# First Build the weighting function
yangObj <- addWeightFunction(yangPims, designVars = c("day", "root"))
evalWeightFunction(yangObj$Wfs$nn, newdata = data.frame("NP" = 2))
}
\seealso{
\link[scam]{predict.scam}, \link{addWeightFunction}
}
