% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCells.R
\name{plotCells}
\alias{plotCells}
\title{Plot the n cells with highest abundance of a feature}
\usage{
plotCells(
  obj,
  features = getFeatures(obj)[seq_len(3)],
  nCells = 100,
  Cex = 1.5,
  borderColVar = NULL,
  borderCols = rev(palette()),
  Mar = c(0.5, 0.1, 0.75, 0.1),
  warnPosition = TRUE,
  summaryFun = "min",
  plotNuclei = !is.null(getHypFrame(obj)$nuclei),
  nucCol = "lightblue",
  scaleBarSize = NULL,
  ...
)
}
\arguments{
\item{obj}{A hyperframe, or an object containing one}

\item{features}{The features to be plotted, a character vector}

\item{nCells}{An integer, the number of cells to be plotted}

\item{Cex}{The point expansion factor}

\item{borderColVar}{The variable to colour borders of the cell}

\item{borderCols}{Colour palette for the borders}

\item{Mar}{the margins}

\item{warnPosition}{A boolean, should a warning be printed on the
image that cells are not in their original location?}

\item{summaryFun}{A function to summarize the gene-cell table in case multiple 
genes are plotted, to determine which cells are plotted.
Choose "min" for cells with the highest minimum, or "sum" for highest total expression
of the combination of genes}

\item{plotNuclei}{A boolean, should nuclei be added?}

\item{nucCol}{A character string, the colour in which the nucleus' boundary is plotted}

\item{scaleBarSize}{A vector of length 2 with the width and height of the scale bars,
in the units of the original point patterns. See details.}

\item{...}{Additional arguments, currently ignored}
}
\value{
Plots cells with highest expression to the plotting window, returns invisible
}
\description{
After testing for within-cell patterns, it may be useful to
look at the cells with the most events for certain genes. These are plotted
here, but the spatial location of the cells in the point pattern is lost!
The choice and ranking of cells is one of decreasing gene (pair) expression.
}
\details{
The width of the scale bar (first element of scaleBarSize) is fixed and the same for all scalebars.
The height of the scale bar will be resized together with the cells to always represent the same physical distance. 
Adding scale bars tacitly assumes that all point patterns are on the same scale.
}
\examples{
example(addCell, "smoppix")
plotCells(hypFrame2, "gene1")
plotCells(hypFrame2, "gene1", borderColVar = "condition", nCells = 10, scaleBarSize = c(.008, .1))
}
