% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf_idf_iae_wrappers.R
\name{idf_igm}
\alias{idf_igm}
\title{labeled inverse cell frequency: IGM}
\usage{
idf_igm(expr, features = NULL, label, lambda = 7, thres = 0)
}
\arguments{
\item{expr}{a matrix, features in row and cells in column}

\item{features}{vector, feature names or indexes to compute}

\item{label}{vector, group label of each cell}

\item{lambda}{numeric, hyperparameter for IGM}

\item{thres}{numeric, cell only counts when expr > threshold, default 0}
}
\value{
a vector of inverse gravity moment score for each feature
}
\description{
labeled inverse cell frequency: IGM
}
\details{
\deqn{\mathbf{IGM_i} = log(1+\lambda\frac{max(n_{i,j\in D})_{k}}{\sum_{k}^{K}((n_{i,j\in D})_{k}*r_{k})+e^{-8}})}
where \eqn{\lambda} is the hyper parameter, \eqn{n_{i,j\in D}} is the number
of cells containing feature \eqn{i} in class \eqn{D}, \eqn{r_k} is the rank
of \eqn{n_{i,j\in D}}.
}
\examples{
data <- matrix(rpois(100, 2), 10, dimnames = list(1:10))
smartid:::idf_igm(data, label = sample(c("A", "B"), 10, replace = TRUE))
}
