% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf_idf_iae_wrappers.R
\name{idf_hdb}
\alias{idf_hdb}
\title{inverse document frequency using hdbscan cluster as label}
\usage{
idf_hdb(expr, features = NULL, multi = TRUE, thres = 0, minPts = 2, ...)
}
\arguments{
\item{expr}{a matrix, features in row and cells in column}

\item{features}{vector, feature names or indexes to compute}

\item{multi}{logical, if to compute based on binary (FALSE) or multi-class (TRUE)}

\item{thres}{numeric, cell only counts when expr > threshold, default 0}

\item{minPts}{integer, minimum size of clusters, default 2.
Details in \code{\link[dbscan:hdbscan]{dbscan::hdbscan()}}.}

\item{...}{parameters for \code{\link[dbscan:hdbscan]{dbscan::hdbscan()}}}
}
\value{
a matrix of inverse cell frequency score
}
\description{
inverse document frequency using hdbscan cluster as label
}
\details{
Details as \code{\link[=idf_prob]{idf_prob()}}.
}
\examples{
set.seed(123)
data <- matrix(rpois(100, 2), 10, dimnames = list(1:10))
smartid:::idf_hdb(data)
}
