% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllHelperFunctions.R
\name{slingReducedDim}
\alias{slingReducedDim}
\alias{slingReducedDim,PseudotimeOrdering-method}
\alias{slingReducedDim,SlingshotDataSet-method}
\alias{slingReducedDim,SingleCellExperiment-method}
\title{Extract dimensionality reduction used by Slingshot}
\usage{
slingReducedDim(x)

\S4method{slingReducedDim}{PseudotimeOrdering}(x)

\S4method{slingReducedDim}{SlingshotDataSet}(x)

\S4method{slingReducedDim}{SingleCellExperiment}(x)
}
\arguments{
\item{x}{an object containing \code{\link{slingshot}} output.}
}
\value{
A matrix of coordinates.
}
\description{
Extract the dimensionality reduction used by 
\code{\link{slingshot}}.
}
\examples{
data("slingshotExample")
rd <- slingshotExample$rd
cl <- slingshotExample$cl
pto <- slingshot(rd, cl, start.clus = '1')
slingReducedDim(pto)
}
