% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllHelperFunctions.R
\name{slingMST}
\alias{slingMST}
\alias{slingMST,PseudotimeOrdering-method}
\alias{slingMST,SingleCellExperiment-method}
\alias{slingMST,SlingshotDataSet-method}
\title{Extract Slingshot minimum spanning tree}
\usage{
slingMST(x, ...)

\S4method{slingMST}{PseudotimeOrdering}(x, as.df = FALSE)

\S4method{slingMST}{SingleCellExperiment}(x, ...)

\S4method{slingMST}{SlingshotDataSet}(x, as.df = FALSE)
}
\arguments{
\item{x}{an object containing \code{\link{slingshot}} output.}

\item{...}{additional parameters to be passed to object-specific methods.}

\item{as.df}{logical, whether to format the output as a \code{data.frame},
suitable for plotting with \code{ggplot}.}
}
\value{
In most cases, output is an \code{\link[igraph]{igraph}} object
  representing the MST. If \code{x} is a \code{SlingshotDataSet}, then output
  is an adjacency matrix representing the MST.
}
\description{
Extract the minimum spanning tree from an object containing
  \code{\link{slingshot}} output.
}
\examples{
data("slingshotExample")
rd <- slingshotExample$rd
cl <- slingshotExample$cl
pto <- slingshot(rd, cl, start.clus = '1')
slingMST(pto)
}
