% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/branchID.R
\name{slingBranchID}
\alias{slingBranchID}
\alias{slingBranchID,ANY-method}
\title{Get slingshot branch labels}
\usage{
slingBranchID(x, ...)

\S4method{slingBranchID}{ANY}(x, thresh = NULL)
}
\arguments{
\item{x}{an object containing \code{slingshot} output, generally either a
\code{\link{PseudotimeOrdering}} or \code{\link{SingleCellExperiment}}.}

\item{...}{additional arguments passed to object-specific methods.}

\item{thresh}{weight threshold for assigning cells to lineages. A cell's
weight on a certain lineage must be at least this value (default =
\code{1/L}, for \code{L} lineages).}
}
\value{
a factor variable that assigns each cell to a particular lineage or
  set of lineages.
}
\description{
Summarizes the lineage assignment weights from \code{slingshot}
  results as a single vector. This is represented by a categorical variable
  indicating which lineage (or combination of lineages) each cell is assigned
  to.
}
\examples{
data("slingshotExample")
rd <- slingshotExample$rd
cl <- slingshotExample$cl
pto <- slingshot(rd, cl)
slingBranchID(pto)

}
