% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/branchID.R
\name{slingBranchGraph}
\alias{slingBranchGraph}
\alias{slingBranchGraph,ANY-method}
\title{Construct graph of slingshot branch labels}
\usage{
slingBranchGraph(x, ...)

\S4method{slingBranchGraph}{ANY}(x, thresh = NULL, max_node_size = 100)
}
\arguments{
\item{x}{an object containing \code{slingshot} output, generally either a
\code{\link{PseudotimeOrdering}} or \code{\link{SingleCellExperiment}}.}

\item{...}{additional arguments passed to object-specific methods.}

\item{thresh}{weight threshold for assigning cells to lineages. A cell's
weight on a certain lineage must be greater than this value (default =
\code{1/L}, for \code{L} lineages).}

\item{max_node_size}{the \code{size} of the largest node in the graph, for
plotting (all others will be drawn proportionally). Default is \code{100}.
See \code{\link[igraph]{igraph.plotting}} for more details.}
}
\value{
an \code{igraph} object representing the relationships between
  lineages.
}
\description{
Builds a graph describing the relationships between the
  different branch assignments.
}
\examples{
data("slingshotExample")
rd <- slingshotExample$rd
cl <- slingshotExample$cl
pto <- slingshot(rd, cl)
slingBranchGraph(pto)
  
}
