% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot3d-SlingshotDataSet}
\alias{plot3d-SlingshotDataSet}
\alias{plot3d.SlingshotDataSet}
\title{Plot Slingshot output in 3D}
\usage{
plot3d.SlingshotDataSet(
  x,
  type = NULL,
  linInd = NULL,
  add = FALSE,
  dims = seq_len(3),
  aspect = "iso",
  size = 10,
  col = 1,
  ...
)
}
\arguments{
\item{x}{a \code{SlingshotDataSet} with results to be plotted.}

\item{type}{character, the type of output to be plotted, can be one of
\code{"lineages"}, \code{curves}, or \code{both} (by partial matching), see
Details for more.}

\item{linInd}{integer, an index indicating which lineages should be plotted
(default is to plot all lineages). If \code{col} is a vector, it will be
subsetted by \code{linInd}.}

\item{add}{logical, indicates whether the output should be added to an
existing plot.}

\item{dims}{numeric, which dimensions to plot (default is \code{1:3}).}

\item{aspect}{either a logical indicating whether to adjust the aspect ratio
or a new ratio, see \code{\link[rgl:plot3d]{plot3d}}.}

\item{size}{numeric, size of points for MST (default is \code{10}), see
\code{\link[rgl:plot3d]{plot3d}}.}

\item{col}{character or numeric, color(s) for lines, see \code{\link{par}}.}

\item{...}{additional parameters to be passed to \code{lines3d}.}
}
\value{
returns \code{NULL}.
}
\description{
Tools for visualizing lineages inferred by \code{slingshot}.
}
\details{
If \code{type == 'lineages'}, straight line connectors between
  cluster centers will be plotted. If \code{type == 'curves'}, simultaneous
  principal curves will be plotted.

When \code{type} is not specified, the function will first check the
  \code{curves} slot and plot the curves, if present. Otherwise,
  \code{lineages} will be plotted, if present.
}
\examples{
\donttest{
library(rgl)
data("slingshotExample")
rd <- slingshotExample$rd
cl <- slingshotExample$cl
rd <- cbind(rd, rnorm(nrow(rd)))
pto <- slingshot(rd, cl, start.clus = "1")
sds <- SlingshotDataSet(pto)
plot3d.SlingshotDataSet(sds, type = 'b')

# add to existing plot
plot3d(rd, col = 'grey50', aspect = 'iso')
plot3d.SlingshotDataSet(sds, lwd = 3, add = TRUE)
}
}
