% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/embedCurves.R
\name{embedCurves}
\alias{embedCurves}
\alias{embedCurves,PseudotimeOrdering,matrix-method}
\alias{embedCurves,SingleCellExperiment,matrix-method}
\alias{embedCurves,SingleCellExperiment,character-method}
\title{Embed trajectory in new space}
\usage{
embedCurves(x, newDimRed, ...)

\S4method{embedCurves}{PseudotimeOrdering,matrix}(
  x,
  newDimRed,
  shrink = NULL,
  stretch = NULL,
  approx_points = NULL,
  smoother = NULL,
  shrink.method = NULL,
  ...
)

\S4method{embedCurves}{SingleCellExperiment,matrix}(
  x,
  newDimRed,
  shrink = NULL,
  stretch = NULL,
  approx_points = NULL,
  smoother = NULL,
  shrink.method = NULL,
  ...
)

\S4method{embedCurves}{SingleCellExperiment,character}(
  x,
  newDimRed,
  shrink = NULL,
  stretch = NULL,
  approx_points = NULL,
  smoother = NULL,
  shrink.method = NULL,
  ...
)
}
\arguments{
\item{x}{an object containing \code{\link{slingshot}} output.}

\item{newDimRed}{a matrix representing the new coordinate space in which to
embed the curves.}

\item{...}{Additional parameters to pass to scatter plot smoothing function,
\code{smoother}.}

\item{shrink}{logical or numeric between 0 and 1, determines whether and how
much to shrink branching lineages toward their average prior to the split.}

\item{stretch}{numeric factor by which curves can be extrapolated beyond
endpoints. Default is \code{2}, see
\code{\link[princurve]{principal_curve}}.}

\item{approx_points}{numeric, whether curves should be approximated by a
fixed number of points. If \code{FALSE} (or 0), no approximation will be
performed and curves will contain as many points as the input data. If
numeric, curves will be approximated by this number of points; preferably
about 100 (see \code{\link[princurve]{principal_curve}}).}

\item{smoother, }{choice of scatter plot smoother. Same as
\code{\link[princurve]{principal_curve}}, but \code{"lowess"} option is
replaced with \code{"loess"} for additional flexibility.}

\item{shrink.method}{character denoting how to determine the appropriate
amount of shrinkage for a branching lineage. Accepted values are the same
as for \code{kernel} in \code{\link{density}} (default is \code{"cosine"}),
as well as \code{"tricube"} and \code{"density"}. See 'Details' for more.}
}
\value{
a \code{\link{PseudotimeOrdering}} object containing curves in the
  new space.
}
\description{
This function takes the output of \code{\link{slingshot}} (or
  \code{\link{getCurves}}) and attempts to embed the curves in a different
  coordinate space than the one in which they were constructed. This should
  be considered a visualization tool, only.
}
\details{
Many of the same parameters are used here as in \code{getCurves}.
  This function attempts to translate curves from one reduced dimensional
  space to another by predicting each dimension as a function of pseudotime
  (ie. the new curve is determined by a series of scatterplot smoothers
  predicting the coordinates in the new space as a function of pseudotime).
  Because the pseudotime values are not changed, this amounts to a single
  iteration of the iterative curve-fitting process used by \code{getCurves}.

Note that non-linear dimensionality reduction techniques (such as
  tSNE and UMAP) may produce discontinuities not observed in other spaces.
  Use caution when embedding curves in these spaces.
}
\examples{
data("slingshotExample")
rd <- slingshotExample$rd
cl <- slingshotExample$cl
pto <- slingshot(rd, cl, start.clus = '1')
rd2 <- cbind(rd[,2] + rnorm(nrow(rd)), -rd[,1] + rnorm(nrow(rd)))
pto.new <- embedCurves(pto, rd2)
pto.new

plot(rd2, col = cl, asp = 1)
lines(SlingshotDataSet(pto.new), lwd = 3)

}
