% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotLoadings}
\alias{plotLoadings}
\title{Plot highest loadings of a factor}
\usage{
plotLoadings(object, term, n_genes = 10)
}
\arguments{
\item{object}{an object of class \code{Rcpp_SlalomModel}}

\item{term}{integer(1) or character(1), providing either index for desired
term (if an integer) or the term name (if character)}

\item{n_genes}{integer(1), number of loadings (genes) to show}
}
\value{
a ggplot plot object
}
\description{
Plot highest loadings of a factor
}
\details{
Show the factor loadings for a genes with the highest loadings for
a given factor. Absolute weights are shown, with genes ordered by absolute
weight. Indications are given on the plot as to whether the gene was
originally in the factor geneset or added to it by the slalom model.
}
\examples{
gmtfile <- system.file("extdata", "reactome_subset.gmt", package = "slalom")
genesets <- GSEABase::getGmt(gmtfile)
data("mesc")
model <- newSlalomModel(mesc, genesets, n_hidden = 5, min_genes = 10)
model <- initSlalom(model)
model <- trainSlalom(model, nIterations = 10)
plotLoadings(model, term = 2)
}
