\name{subsetProbes}
\alias{subsetProbes}

\title{
Conveniently subset probes by type and retrieve the methylated or unmethylated intensities
}
\description{
Thus function accepts a \code{MethyLumiSet} object generated by \code{methylumi} or a \code{MethylSet} object generated by \code{minfi}. It will subset the probes by type--\code{"I-red"}, \code{"I-green"}, or \code{"II"}--and return a matrix of the methylated, \code{"M"}, or unmethylated, \code{"U"} signal intensities. It is also possible to include or filter out probes according to whether they are CpG sites(cg), SNPs(rs), imprinted(idmr) gene sites, or non-CpG loci(ch).
}
\usage{
subsetProbes(object, allele = c("M", "U"),
              type = c("I-red", "I-green", "II"),
              cg = TRUE, snps = TRUE, idmr = TRUE, ch = FALSE)
}

\arguments{
  \item{object}{
A \code{MethyLumiSet} or \code{MethylSet} object
}
  \item{allele}{
Should methylated or unmethylated data for the probes be returned.
}
  \item{type}{
May be \code{"I-red"}, \code{"I-green"}, or {"II"}.
}
  \item{cg}{
Logical; Should the returned dataset contain the CpG probes. The default is \code{TRUE}
}
  \item{snps}{
Logical; Should the returned dataset conain the rs probes. The default is \code{TRUE}
}
  \item{idmr}{
Logical; should the returned dataset include probes that interrogate imprinted gene sites as given by Pidsley et al.(2013). The default is \code{TRUE}
}
  \item{ch}{
Logical; should the returned dataset include the non-CpG (ch) probes. The default if \code{FALSE}
}
}

\value{
A \code{matrix}
}
\references{
Pidsley R, Wong CCY, Volta M, Lunnon K, Mill J, Schalwyk LC(2013). A data-driven approach to preprocessing Illumina 450k methylation array data. BMC Genomics, 14:293.
}
\author{
Ryan Putney \email{ryanputney@gmail.com}
}

\seealso{
\code{\link{getSNparams}}
}
\examples{
if(require('wateRmelon')) {
  data(melon)
  melon.meth.II <- subsetProbes(melon, 'M', 'II')
}
}

\keyword{ manip }

