% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permuTest.R
\name{generateNull_intl}
\alias{generateNull_intl}
\title{Permutation test for the derived scores of each sample}
\usage{
generateNull_intl(
  upSet,
  downSet = NULL,
  rankData,
  subSamples = NULL,
  centerScore = TRUE,
  knownDirection = TRUE,
  B = 1000,
  ncores = 1,
  seed = sample.int(1e+06, 1),
  useBPPARAM = NULL
)
}
\arguments{
\item{downSet}{A GeneSet object, down regulated gene set}

\item{rankData}{matrix, outcome of function \code{\link[=rankGenes]{rankGenes()}}}

\item{centerScore}{A Boolean, specifying whether scores should be centered
around 0, default as TRUE}

\item{knownDirection}{A boolean flag, it deterimines whether the scoring
method should derive the scores in a directional mannar when the gene
signature only contains one set of gene set (passing the gene set via
upSet). It is default as TRUE but one can set the argument to be FALSE to
derive the score for a single gene set in a undirectional way. This
parameter becomes irrelevant when both upSet and downSet are provided.}

\item{B}{integer, the number of permutation repeats or the number of random
gene sets to be generated, default as 1,000}

\item{ncores, }{integer, the number of CPU cores the function can use}

\item{seed}{integer, set the seed for randomisation}

\item{useBPPARAM, }{the backend the function uses, if NULL is provided, the
function uses the default parallel backend which is the first on the list
returned by \code{BiocParallel::registered()} i.e
\code{BiocParallel::registered()[[1]]} for your machine. It can be changed
explicitly by passing a BPPARAM}
}
\value{
A matrix of empirical scores for all samples
}
\description{
This function generates a number of random gene sets that
have the same number of genes as the scored gene set. It scores each random
gene set and returns a matrix of scores for all samples.
The empirical scores are used to calculate the empirical p-values and plot
the null distribution. The implementation uses \code{\link[BiocParallel:bplapply]{BiocParallel::bplapply()}}
for easy access to parallel backends. Note that one should pass the same
values to the \code{upSet}, \code{downSet}, \code{centerScore} and \code{knownDirection}
arguments as what they provide for the \code{simpleScore()} function to generate
a proper null distribution.
}
\seealso{
\href{http://lcolladotor.github.io/2016/03/07/BiocParallel/#.WgXMF61L28U}{Post about BiocParallel}
\code{browseVignettes("BiocParallel")}
}
\author{
Ruqian Lyu
}
\keyword{internal}
