% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runUMAP.R
\name{runUMAP}
\alias{runUMAP}
\alias{runQuickUMAP}
\alias{getUMAP}
\title{Run UMAP embedding with scater method}
\usage{
runUMAP(
  inSCE,
  useReducedDim = "PCA",
  useAssay = NULL,
  useAltExp = NULL,
  sample = NULL,
  reducedDimName = "UMAP",
  logNorm = TRUE,
  useFeatureSubset = NULL,
  nTop = 2000,
  scale = TRUE,
  pca = TRUE,
  initialDims = 10,
  nNeighbors = 30,
  nIterations = 200,
  alpha = 1,
  minDist = 0.01,
  spread = 1,
  seed = 12345,
  verbose = TRUE,
  BPPARAM = SerialParam()
)

runQuickUMAP(inSCE, useAssay = "counts", sample = "sample", ...)

getUMAP(
  inSCE,
  useReducedDim = "PCA",
  useAssay = NULL,
  useAltExp = NULL,
  sample = NULL,
  reducedDimName = "UMAP",
  logNorm = TRUE,
  useFeatureSubset = NULL,
  nTop = 2000,
  scale = TRUE,
  pca = TRUE,
  initialDims = 25,
  nNeighbors = 30,
  nIterations = 200,
  alpha = 1,
  minDist = 0.01,
  spread = 1,
  seed = 12345,
  BPPARAM = SerialParam()
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object.}

\item{useReducedDim}{The low dimension representation to use for UMAP
computation. If \code{useAltExp} is specified, \code{useReducedDim} has to
exist in \code{reducedDims(altExp(inSCE, useAltExp))}. Default \code{"PCA"}.}

\item{useAssay}{Assay to use for UMAP computation. If \code{useAltExp} is
specified, \code{useAssay} has to exist in
\code{assays(altExp(inSCE, useAltExp))}. Ignored when using
\code{useReducedDim}. Default \code{NULL}.}

\item{useAltExp}{The subset to use for UMAP computation, usually for the
selected variable features. Default \code{NULL}.}

\item{sample}{Character vector. Indicates which sample each cell belongs to.
If given a single character, will take the annotation from \code{colData}.
Default \code{NULL}.}

\item{reducedDimName}{A name to store the results of the UMAP embedding
coordinates obtained from this method. Default \code{"UMAP"}.}

\item{logNorm}{Whether the counts will need to be log-normalized prior to
generating the UMAP via \code{\link{scaterlogNormCounts}}. Ignored when using
\code{useReducedDim}. Default \code{TRUE}.}

\item{useFeatureSubset}{Subset of feature to use for dimension reduction. A
character string indicating a \code{rowData} variable that stores the logical
vector of HVG selection, or a vector that can subset the rows of
\code{inSCE}. Default \code{NULL}.}

\item{nTop}{Automatically detect this number of variable features to use for
dimension reduction. Ignored when using \code{useReducedDim} or using
\code{useFeatureSubset}. Default \code{2000}.}

\item{scale}{Whether \code{useAssay} matrix will need to be standardized.
Default \code{TRUE}.}

\item{pca}{Logical. Whether to perform dimension reduction with PCA before
UMAP. Ignored when using \code{useReducedDim}. Default \code{TRUE}.}

\item{initialDims}{Number of dimensions from PCA to use as input in UMAP.
Default \code{10}.}

\item{nNeighbors}{The size of local neighborhood used for manifold
approximation. Larger values result in more global views of the manifold,
while smaller values result in more local data being preserved. Default
\code{30}. See \code{\link[scater]{calculateUMAP}} for more information.}

\item{nIterations}{The number of iterations performed during layout
optimization. Default is \code{200}.}

\item{alpha}{The initial value of "learning rate" of layout optimization.
Default is \code{1}.}

\item{minDist}{The effective minimum distance between embedded points.
Smaller values will result in a more clustered/clumped embedding where nearby
points on the manifold are drawn closer together, while larger values will
result on a more even dispersal of points. Default \code{0.01}. See
\code{\link[scater]{calculateUMAP}} for more information.}

\item{spread}{The effective scale of embedded points. In combination with
\code{minDist}, this determines how clustered/clumped the embedded points
are. Default \code{1}. See \code{\link[scater]{calculateUMAP}} for more
information.}

\item{seed}{Random seed for reproducibility of UMAP results.
Default \code{NULL} will use global seed in use by the R environment.}

\item{verbose}{Logical. Whether to print log messages. Default \code{TRUE}.}

\item{BPPARAM}{A \linkS4class{BiocParallelParam} object specifying whether
the PCA should be parallelized.}

\item{...}{Parameters passed to \code{runUMAP}}
}
\value{
A \linkS4class{SingleCellExperiment} object with UMAP computation
updated in \code{reducedDim(inSCE, reducedDimName)}.
}
\description{
Uniform Manifold Approximation and Projection (UMAP) algorithm
is commonly for 2D visualization of single-cell data. These functions wrap 
the scater \code{\link[scater]{calculateUMAP}} function.

Users can use \code{runQuickUMAP} to directly create UMAP embedding from raw
count matrix, with necessary preprocessing including normalization, variable
feature selection, scaling, dimension reduction all automated. Therefore, 
\code{useReducedDim} is disabled for \code{runQuickUMAP}. 

In a complete analysis, we still recommend having dimension reduction such as
PCA created beforehand and select proper numbers of dimensions for using
\code{runUMAP}, so that the result can match with the clustering based on the
same input PCA.
}
\examples{
data(scExample, package = "singleCellTK")
sce <- subsetSCECols(sce, colData = "type != 'EmptyDroplet'")
# Run from raw counts
sce <- runQuickUMAP(sce)
plotDimRed(sce, "UMAP")

}
