% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggPlotting.R
\name{plotSCEDensity}
\alias{plotSCEDensity}
\title{Density plot of any data stored in the SingleCellExperiment object.}
\usage{
plotSCEDensity(
  inSCE,
  slotName,
  itemName,
  sample = NULL,
  feature = NULL,
  dimension = NULL,
  groupBy = NULL,
  xlab = NULL,
  ylab = NULL,
  axisSize = 10,
  axisLabelSize = 10,
  defaultTheme = TRUE,
  title = NULL,
  titleSize = 18,
  cutoff = NULL,
  combinePlot = "none",
  plotLabels = NULL
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object with saved
dimension reduction components or a variable with saved results. Required.}

\item{slotName}{Desired slot of SingleCellExperiment used for plotting. Possible
options: "assays", "colData", "metadata", "reducedDims". Required.}

\item{itemName}{Desired vector within the slot used for plotting. Required.}

\item{sample}{Character vector. Indicates which sample each cell belongs to.}

\item{feature}{Desired name of feature stored in assay of SingleCellExperiment
object. Only used when "assays" slotName is selected. Default NULL.}

\item{dimension}{Desired dimension stored in the specified reducedDims.
Either an integer which indicates the column or a character vector specifies
column name. By default, the 1st dimension/column will be used.
Only used when "reducedDims" slotName is selected. Default NULL.}

\item{groupBy}{Groupings for each numeric value. A user may input a vector
equal length to the number of the samples in the SingleCellExperiment
object, or can be retrieved from the colData slot. Default NULL.}

\item{xlab}{Character vector. Label for x-axis. Default NULL.}

\item{ylab}{Character vector. Label for y-axis. Default NULL.}

\item{axisSize}{Size of x/y-axis ticks. Default 10.}

\item{axisLabelSize}{Size of x/y-axis labels. Default 10.}

\item{defaultTheme}{Removes grid in plot and sets axis title size to 10
when TRUE. Default TRUE.}

\item{title}{Title of plot. Default NULL.}

\item{titleSize}{Size of title of plot. Default 15.}

\item{cutoff}{Numeric value. The plot will be annotated with a vertical line
if set. Default NULL.}

\item{combinePlot}{Must be either "all", "sample", or "none". "all" will combine all plots into a single
.ggplot object, while "sample" will output a list of plots separated by sample. Default "none".}

\item{plotLabels}{labels to each plot. If set to "default", will use the name of the samples
as the labels. If set to "none", no label will be plotted.}
}
\value{
a ggplot object of the density plot.
}
\description{
Visualizes values stored in any slot of a
 SingleCellExperiment object via a densityn plot.
}
\examples{
data("mouseBrainSubsetSCE")
plotSCEDensity(
  inSCE = mouseBrainSubsetSCE, slotName = "assays",
  itemName = "counts", feature = "Apoe", groupBy = "sex"
)
}
