% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runBatchCorrection.R
\name{runZINBWaVE}
\alias{runZINBWaVE}
\title{Apply ZINBWaVE Batch effect correction method to SingleCellExperiment object}
\usage{
runZINBWaVE(
  inSCE,
  useAssay = "counts",
  batch = "batch",
  nHVG = 1000L,
  nComponents = 50L,
  epsilon = 1000,
  nIter = 10L,
  reducedDimName = "zinbwave",
  BPPARAM = BiocParallel::SerialParam()
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object}

\item{useAssay}{A single character indicating the name of the assay requiring
batch correction. Note that ZINBWaVE works for counts (integer) input rather
than logcounts that other methods prefer. Default \code{"counts"}.}

\item{batch}{A single character indicating a field in
\code{\link{colData}} that annotates the batches.
Default \code{"batch"}.}

\item{nHVG}{An integer. Number of highly variable genes to use when fitting
the model. Default \code{1000L}.}

\item{nComponents}{An integer. The number of principle components or
dimensionality to generate in the resulting matrix. Default \code{50L}.}

\item{epsilon}{An integer. Algorithmic parameter. Empirically, a high epsilon
is often required to obtained a good low-level representation. Default
\code{1000L}.}

\item{nIter}{An integer, The max number of iterations to perform. Default
\code{10L}.}

\item{reducedDimName}{A single character. The name for the corrected
low-dimensional representation. Will be saved to \code{reducedDim(inSCE)}.
Default \code{"zinbwave"}.}

\item{BPPARAM}{A \linkS4class{BiocParallelParam} object specifying whether
should be parallelized. Default \code{BiocParallel::SerialParam()}.}
}
\value{
The input \linkS4class{SingleCellExperiment} object with
\code{reducedDim(inSCE, reducedDimName)} updated.
}
\description{
A general and flexible zero-inflated negative binomial model that can be
used to provide a low-dimensional representations of scRNAseq data. The
model accounts for zero inflation (dropouts), over-dispersion, and the count
nature of the data. The model also accounts for the difference in library
sizes and optionally for batch effects and/or other covariates.
}
\examples{
data('sceBatches', package = 'singleCellTK')
\dontrun{
    sceCorr <- runZINBWaVE(sceBatches, nIter = 5)
}
}
\references{
Pollen, Alex A et al., 2014
}
