% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanpyFunctions.R
\name{runScanpyUMAP}
\alias{runScanpyUMAP}
\title{runScanpyUMAP
Computes UMAP from the given sce object and stores the UMAP computations back
into the sce object}
\usage{
runScanpyUMAP(
  inSCE,
  useAssay = NULL,
  useReducedDim = "scanpyPCA",
  reducedDimName = "scanpyUMAP",
  dims = 40,
  minDist = 0.5,
  nNeighbors = 10,
  spread = 1,
  alpha = 1,
  gamma = 1,
  externalReduction = NULL,
  seed = 12345
)
}
\arguments{
\item{inSCE}{(sce) object on which to compute the UMAP}

\item{useAssay}{Specify name of assay to use. Default is \code{NULL}, so
\code{useReducedDim} param will be used instead.}

\item{useReducedDim}{Reduction to use for computing UMAP. 
Default is \code{"scanpyPCA"}.}

\item{reducedDimName}{Name of new reducedDims object containing Scanpy UMAP
Default \code{scanpyUMAP}.}

\item{dims}{Numerical value of how many reduction components to use for UMAP
computation. Default \code{40}.}

\item{minDist}{Sets the \code{"min_dist"} parameter to the underlying UMAP
call. Default \code{0.5}.}

\item{nNeighbors}{Sets the \code{"n_neighbors"} parameter to the underlying
UMAP call. Default \code{10}.}

\item{spread}{Sets the \code{"spread"} parameter to the underlying UMAP call.
Default \code{1}.}

\item{alpha}{Sets the \code{"alpha"} parameter to the underlying UMAP call.
Default \code{1}.}

\item{gamma}{Sets the \code{"gamma"} parameter to the underlying UMAP call.
Default \code{1}.}

\item{externalReduction}{Pass DimReduce object if PCA computed through
other libraries. Default \code{NULL}.}

\item{seed}{Specify numeric value to set as a seed. Default \code{12345}.}
}
\value{
Updated sce object with UMAP computations stored
}
\description{
runScanpyUMAP
Computes UMAP from the given sce object and stores the UMAP computations back
into the sce object
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runScanpyNormalizeData(sce, useAssay = "counts")
sce <- runScanpyFindHVG(sce, useAssay = "scanpyNormData", method = "seurat")
sce <- runScanpyScaleData(sce, useAssay = "scanpyNormData")
sce <- runScanpyPCA(sce, useAssay = "scanpyScaledData")
sce <- runScanpyFindClusters(sce, useReducedDim = "scanpyPCA")
sce <- runScanpyUMAP(sce, useReducedDim = "scanpyPCA")
}
}
