% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sctkQCUtils.R
\name{exportSCEToSeurat}
\alias{exportSCEToSeurat}
\title{Export data in Seurat object}
\usage{
exportSCEToSeurat(
  inSCE,
  prefix = "sample",
  outputDir = "./",
  overwrite = TRUE,
  copyColData = TRUE,
  copyReducedDim = TRUE,
  copyDecontX = TRUE
)
}
\arguments{
\item{inSCE}{A \link[SingleCellExperiment]{SingleCellExperiment} object
that contains the data. QC metrics are stored in colData of the
singleCellExperiment object.}

\item{prefix}{Prefix to use for the name of the output file. Default \code{"sample"}.}

\item{outputDir}{Path to the directory where outputs will be written. Default is the current working directory.}

\item{overwrite}{Boolean. Whether overwrite the output if it already exists in the outputDir. Default \code{TRUE}.}

\item{copyColData}{Boolean. Whether copy 'colData' of SCE object to the 'meta.data' of Seurat object. Default \code{TRUE}.}

\item{copyReducedDim}{Boolean. Whether copy 'reducedDims' of the SCE object to the 'reductions' of Seurat object. Default \code{TRUE}.}

\item{copyDecontX}{Boolean. Whether copy 'decontXcounts' assay of the SCE object to the 'assays' of Seurat object. Default \code{TRUE}.}
}
\value{
Generates a Seurat object containing data from \code{inSCE}.
}
\description{
Export data in Seurat object
}
