% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importGeneSets.R
\name{sctkListGeneSetCollections}
\alias{sctkListGeneSetCollections}
\title{Lists imported GeneSetCollections}
\usage{
sctkListGeneSetCollections(inSCE)
}
\arguments{
\item{inSCE}{A \link[SingleCellExperiment]{SingleCellExperiment} object.}
}
\value{
Character vector.
}
\description{
Returns a vector of GeneSetCollections that have been
imported and stored in \code{metadata(inSCE)$sctk$genesets}.
}
\examples{
data(scExample)
gs1 <- GSEABase::GeneSet(setName = "geneset1",
                         geneIds = rownames(sce)[seq(10)])
gs2 <- GSEABase::GeneSet(setName = "geneset2",
                         geneIds = rownames(sce)[seq(11,20)])
gsc1 <- GSEABase::GeneSetCollection(gs1)
gsc2 <- GSEABase::GeneSetCollection(gs2)
sce <- importGeneSetsFromCollection(inSCE = sce,
                                    geneSetCollection = gsc1,
                                    by = "rownames",
                                    collectionName = "Collection1")
sce <- importGeneSetsFromCollection(inSCE = sce,
                                    geneSetCollection = gsc2,
                                    by = "rownames",
                                    collectionName = "Collection2")
collections <- sctkListGeneSetCollections(sce)
}
\seealso{
\link{importGeneSetsFromList} for importing from lists,
\link{importGeneSetsFromGMT} for importing from GMT files,
\linkS4class{GeneSetCollection} objects, and \link{importGeneSetsFromMSigDB}
for importing MSigDB gene sets.
}
\author{
Joshua D. Campbell
}
