% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seuratFunctions.R
\name{runSeuratSCTransform}
\alias{runSeuratSCTransform}
\title{runSeuratSCTransform
Runs the \link[Seurat]{SCTransform} function to transform/normalize the input
data}
\usage{
runSeuratSCTransform(
  inSCE,
  normAssayName = "SCTCounts",
  useAssay = "counts",
  verbose = TRUE
)
}
\arguments{
\item{inSCE}{Input SingleCellExperiment object}

\item{normAssayName}{Name for the output data assay. Default
\code{"SCTCounts"}.}

\item{useAssay}{Name for the input data assay. Default \code{"counts"}.}

\item{verbose}{Logical value indicating if informative messages should
be displayed. Default is \code{TRUE}.}
}
\value{
Updated SingleCellExperiment object containing the transformed data
}
\description{
runSeuratSCTransform
Runs the \link[Seurat]{SCTransform} function to transform/normalize the input
data
}
\examples{
data("mouseBrainSubsetSCE", package = "singleCellTK")
mouseBrainSubsetSCE <- runSeuratSCTransform(mouseBrainSubsetSCE)
}
