% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runCluster.R
\name{runScranSNN}
\alias{runScranSNN}
\title{Get clustering with SNN graph}
\usage{
runScranSNN(
  inSCE,
  useReducedDim = "PCA",
  useAssay = NULL,
  useAltExp = NULL,
  altExpAssay = "counts",
  altExpRedDim = NULL,
  clusterName = "cluster",
  k = 14,
  nComp = 10,
  weightType = "jaccard",
  algorithm = c("louvain", "leiden", "walktrap", "infomap", "fastGreedy", "labelProp",
    "leadingEigen"),
  BPPARAM = BiocParallel::SerialParam(),
  seed = 12345,
  ...
)
}
\arguments{
\item{inSCE}{A \linkS4class{SingleCellExperiment} object.}

\item{useReducedDim}{A single \code{character}, specifying which
low-dimension representation (\code{\link{reducedDim}})
to perform the clustering algorithm on. Default \code{"PCA"}.}

\item{useAssay}{A single \code{character}, specifying which
\code{\link{assay}} to perform the clustering algorithm
on. Default \code{NULL}.}

\item{useAltExp}{A single \code{character}, specifying the assay which
\code{\link{altExp}} to perform the clustering
algorithm on. Default \code{NULL}.}

\item{altExpAssay}{A single \code{character}, specifying which
\code{\link{assay}} in the chosen
\code{\link{altExp}} to work on. Only used when
\code{useAltExp} is set. Default \code{"counts"}.}

\item{altExpRedDim}{A single \code{character}, specifying which
\code{\link{reducedDim}} within the \code{\link{altExp}} specified by
\code{useAltExp} to use. Only used when \code{useAltExp} is set. Default
\code{NULL}.}

\item{clusterName}{A single \code{character}, specifying the name to store
the cluster label in \code{\link{colData}}. Default
\code{"cluster"}.}

\item{k}{An \code{integer}, the number of nearest neighbors used to construct
the graph. Smaller value indicates higher resolution and larger number of
clusters. Default \code{14}.}

\item{nComp}{An \code{integer}. The number of components to use for graph
construction. Default \code{10}. See Detail.}

\item{weightType}{A single \code{character}, that specifies the edge weighing
scheme when constructing the Shared Nearest-Neighbor (SNN) graph. Choose from
\code{"rank"}, \code{"number"}, \code{"jaccard"}. Default \code{"jaccard"}.}

\item{algorithm}{A single \code{character}, that specifies the community
detection algorithm to work on the SNN graph. Choose from \code{"leiden"},
\code{"louvain"}, \code{"walktrap"}, \code{"infomap"}, \code{"fastGreedy"},
\code{"labelProp"}, \code{"leadingEigen"}. Default \code{"louvain"}. See
Detail.}

\item{BPPARAM}{A \code{\link[BiocParallel]{BiocParallelParam}} object to use
for processing the SNN graph generation step in parallel.}

\item{seed}{Random seed for reproducibility of results. Default \code{NULL}
will use global seed in use by the R environment.}

\item{...}{Other optional parameters passed to the \code{\link{igraph}}
clustering functions. See Details.}
}
\value{
The input \linkS4class{SingleCellExperiment} object with
\code{factor} cluster labeling updated in
\code{colData(inSCE)[[clusterName]]}.
}
\description{
Perform SNN graph clustering on a
\linkS4class{SingleCellExperiment} object, with graph
construction by \code{\link[scran]{buildSNNGraph}} and graph clustering by
"igraph" package.
}
\details{
Different graph based clustering algorithms have diverse sets of
parameters that users can tweak. The help information can be found here:
\itemize{
 \item{for \code{"louvain"}, see function help
 \code{\link[igraph]{cluster_louvain}}}
 \item{for \code{"leiden"}, see function help
 \code{\link[igraph]{cluster_leiden}}}
 \item{for \code{"walktrap"}, see function help
 \code{\link[igraph]{cluster_walktrap}}}
 \item{for \code{"infomap"}, see function help
 \code{\link[igraph]{cluster_infomap}}}
 \item{for \code{"fastGreedy"}, see function help
 \code{\link[igraph]{cluster_fast_greedy}}}
 \item{for \code{"labelProp"}, see function help
 \code{\link[igraph]{cluster_label_prop}}}
 \item{for \code{"leadingEigen"}, see function help
 \code{\link[igraph]{cluster_leading_eigen}}}
}

The Scran SNN building method can work on specified \code{nComp} components.
When users specify input matrix by \code{useAssay} or \code{useAltExp} +
\code{altExpAssay}, the method will generate \code{nComp} components and use
them all. When specifying \code{useReducedDim} or \code{useAltExp} +
\code{altExpRedDim}, this function will subset the top \code{nComp}
components and pass them to the method.
}
\examples{
data("mouseBrainSubsetSCE")
mouseBrainSubsetSCE <- runScranSNN(mouseBrainSubsetSCE,
                                   useReducedDim = "PCA_logcounts")
}
\references{
Aaron Lun and et. al., 2016
}
