% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scds_doubletdetection.R
\name{runCxds}
\alias{runCxds}
\title{Find doublets/multiplets using \link[scds]{cxds}.}
\usage{
runCxds(
  inSCE,
  sample = NULL,
  seed = 12345,
  ntop = 500,
  binThresh = 0,
  verb = FALSE,
  retRes = FALSE,
  estNdbl = FALSE,
  useAssay = "counts"
)
}
\arguments{
\item{inSCE}{A \linkS4class{SingleCellExperiment} object.}

\item{sample}{Character vector or colData variable name. Indicates which 
sample each cell belongs to. Default \code{NULL}.}

\item{seed}{Seed for the random number generator, can be \code{NULL}. Default
\code{12345}.}

\item{ntop}{See \link[scds]{cxds} for more information. Default \code{500}.}

\item{binThresh}{See \link[scds]{cxds} for more information. Default 
\code{0}.}

\item{verb}{See \link[scds]{cxds} for more information. Default \code{FALSE}.}

\item{retRes}{See \link[scds]{cxds} for more information. Default 
\code{FALSE}.}

\item{estNdbl}{See \link[scds]{cxds} for more information. Default 
\code{FALSE}.}

\item{useAssay}{A string specifying which assay in the SCE to use. Default 
\code{"counts"}}
}
\value{
A \linkS4class{SingleCellExperiment} object with \link[scds]{cxds} 
output appended to the \link{colData} slot. The columns include 
\emph{cxds_score} and optionally \emph{cxds_call}.
}
\description{
A wrapper function for \link[scds]{cxds}. Annotate
doublets/multiplets using co-expression based approach. Generate a doublet
score for each cell. Infer doublets if \code{estNdbl} is \code{TRUE}.
}
\details{
When the argument \code{sample} is specified, \link[scds]{cxds} will
be run on cells from each sample separately. If \code{sample = NULL}, then 
all cells will be processed together.
}
\examples{
data(scExample, package = "singleCellTK")
sce <- subsetSCECols(sce, colData = "type != 'EmptyDroplet'")
sce <- runCxds(sce)
}
\seealso{
\code{\link[scds]{cxds}}, \code{\link{plotCxdsResults}}, 
\code{\link{runCellQC}}
}
