% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanpyFunctions.R
\name{plotScanpyViolin}
\alias{plotScanpyViolin}
\title{plotScanpyViolin}
\usage{
plotScanpyViolin(
  inSCE,
  useAssay = NULL,
  features,
  groupBy,
  xlabel = "",
  ylabel = NULL
)
}
\arguments{
\item{inSCE}{Input \code{SingleCellExperiment} object.}

\item{useAssay}{Assay to use for plotting. By default it will use counts
assay.}

\item{features}{Genes to plot. Sometimes is useful to pass a specific list of
var names (e.g. genes). The var_names could be a dictionary or a list.}

\item{groupBy}{The key of the observation grouping to consider.}

\item{xlabel}{Label of the x axis. Defaults to groupBy.}

\item{ylabel}{Label of the y axis. If NULL and groupBy is NULL, 
defaults to 'value'. If NULL and groupBy is not NULL, defaults to features.}
}
\value{
plot object
}
\description{
plotScanpyViolin
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runScanpyNormalizeData(sce, useAssay = "counts")
sce <- runScanpyFindHVG(sce, useAssay = "scanpyNormData", method = "seurat")
sce <- runScanpyScaleData(sce, useAssay = "scanpyNormData")
sce <- runScanpyPCA(sce, useAssay = "scanpyScaledData")
sce <- runScanpyFindClusters(sce, useReducedDim = "scanpyPCA")
sce <- runScanpyUMAP(sce, useReducedDim = "scanpyPCA")
markers <- c("MALAT1" ,"RPS27" ,"CST3")
plotScanpyViolin(sce, features = markers, groupBy = "Scanpy_louvain_1")
}
}
