% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPCA.R
\name{plotPCA}
\alias{plotPCA}
\title{Plot PCA run data from its components.}
\usage{
plotPCA(
  inSCE,
  colorBy = NULL,
  shape = NULL,
  pcX = "PC1",
  pcY = "PC2",
  reducedDimName = "PCA",
  runPCA = FALSE,
  useAssay = "logcounts"
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object.}

\item{colorBy}{The variable to color clusters by}

\item{shape}{Shape of the points}

\item{pcX}{User choice for the first principal component}

\item{pcY}{User choice for the second principal component}

\item{reducedDimName}{a name to store the results of the dimension reduction
coordinates obtained from this method. This is stored in the SingleCellExperiment
object in the reducedDims slot. Required.}

\item{runPCA}{Run PCA if the reducedDimName does not exist. the Default is
FALSE.}

\item{useAssay}{Indicate which assay to use. The default is "logcounts".}
}
\value{
A PCA plot
}
\description{
Plot PCA run data from its components.
}
\examples{
data("mouseBrainSubsetSCE")
plotPCA(mouseBrainSubsetSCE, colorBy = "level1class",
        reducedDimName = "PCA_counts")
}
