% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importGeneSets.R
\name{importGeneSetsFromGMT}
\alias{importGeneSetsFromGMT}
\title{Imports gene sets from a GMT file}
\usage{
importGeneSetsFromGMT(
  inSCE,
  file,
  collectionName = "GeneSetCollection",
  by = "rownames",
  sep = "\\t",
  noMatchError = TRUE
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object.}

\item{file}{Character. Path to GMT file. See \link{getGmt} for
more information on reading GMT files.}

\item{collectionName}{Character. Name of collection to add gene sets to.
If this collection already exists in \code{inSCE}, then these gene sets will
be added to that collection. Any gene sets within the collection with the
same name will be overwritten. Default \code{GeneSetCollection}.}

\item{by}{Character, character vector, or NULL. Describes the
location within \code{inSCE} where the gene identifiers in
\code{geneSetList} should be mapped. If set to \code{"rownames"} then the
features will be searched for among \code{rownames(inSCE)}. This can also be
set to one of the column names of \code{rowData(inSCE)} in which case the
gene identifies will be mapped to that column in the \code{rowData}
of \code{inSCE}. \code{by} can be a vector the same length as
the number of gene sets in the GMT file and the elements of the vector
can point to different locations within \code{inSCE}. Finally, \code{by}
can be \code{NULL}. In this case, the location of the gene identifiers
in \code{inSCE} should be saved in the description (2nd column)
of the GMT file. See \link{featureIndex} for more information.
Default \code{"rownames"}.}

\item{sep}{Character. Delimiter of the GMT file. Default \code{"\t"}.}

\item{noMatchError}{Boolean. Show an error if a collection does not have
any matching features. Default \code{TRUE}.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object
 with gene set from \code{collectionName} output stored to the
 \link{metadata} slot.
}
\description{
Converts a list of gene sets stored in a GMT file into a
\linkS4class{GeneSetCollection} and stores it in the metadata of the
\linkS4class{SingleCellExperiment} object. These gene sets can be used in
downstream quality control and analysis functions in \link{singleCellTK}.
}
\details{
The gene identifiers in gene sets in the GMT file will be
mapped to the rownames of \code{inSCE} using the \code{by} parameter and
stored in a \linkS4class{GeneSetCollection} object from package
\link{GSEABase}. This object is stored in
\code{metadata(inSCE)$sctk$genesets}, which can be accessed in downstream
analysis functions such as \link[singleCellTK]{runCellQC}.
}
\examples{
data(scExample)

# GMT file containing gene symbols for a subset of human mitochondrial genes
gmt <- system.file("extdata/mito_subset.gmt", package = "singleCellTK")

# "feature_name" is the second column in the GMT file, so the ids will
# be mapped using this column in the 'rowData' of 'sce'. This
# could also be accomplished by setting by = "feature_name" in the
# function call.
sce <- importGeneSetsFromGMT(inSCE = sce, file = gmt, by = NULL)
}
\seealso{
\link{importGeneSetsFromList} for importing from lists,
\link{importGeneSetsFromCollection} for importing from
\linkS4class{GeneSetCollection} objects, and
\link{importGeneSetsFromMSigDB} for importing MSigDB gene sets.
}
\author{
Joshua D. Campbell
}
