% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscFunctions.R
\name{discreteColorPalette}
\alias{discreteColorPalette}
\title{Generate given number of color codes}
\usage{
discreteColorPalette(
  n,
  palette = c("random", "ggplot", "celda"),
  seed = 12345,
  ...
)
}
\arguments{
\item{n}{An integer, the number of color codes to generate.}

\item{palette}{A single character string. Select the method, available
options are \code{"ggplot"}, \code{"celda"} and \code{"random"}. Default
\code{"random"}.}

\item{seed}{An integer. Set the seed for random process that happens only in
"random" generation. Default \code{12345}.}

\item{...}{Other arguments that are passed to the internal function,
according to the method selected.}
}
\value{
A character vector of \code{n} hex color codes.
}
\description{
Three different generation methods are wrapped, including
\code{\link[celda]{distinctColors}},
[randomcoloR](SCTK_PerformingQC_Cell_V3.Rmd) and the \code{ggplot}
default color generation.
}
\examples{
discreteColorPalette(n = 3)
}
