% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectCellOutlier.R
\name{detectCellOutlier}
\alias{detectCellOutlier}
\title{Detecting outliers within the SingleCellExperiment object.}
\usage{
detectCellOutlier(
  inSCE,
  slotName,
  itemName,
  sample = NULL,
  nmads = 3,
  type = "both",
  overwrite = TRUE
)
}
\arguments{
\item{inSCE}{A \link[SingleCellExperiment]{SingleCellExperiment} object.}

\item{slotName}{Desired slot of SingleCellExperiment used for plotting. Possible
options: "assays", "colData", "metadata", "reducedDims". Required.}

\item{itemName}{Desired vector within the slot used for plotting. Required.}

\item{sample}{A single character specifying a name that can be found in
\code{colData(inSCE)} to directly use the cell annotation; or a character
vector with as many elements as cells to indicates which sample each cell
belongs to. Default NULL. \link[celda]{decontX} will be run on cells from
each sample separately.}

\item{nmads}{Integer. Number of median absolute deviation. Parameter may be
adjusted for more lenient or stringent outlier cutoff. Default 3.}

\item{type}{Character. Type/direction of outlier detection; whether
the lower/higher outliers should be detected, or both.
Options are "both", "lower", "higher".}

\item{overwrite}{Boolean. If TRUE, and this function has previously generated
an outlier decision on the same itemName, the outlier decision will be overwritten.
Default TRUE.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object with
 '' added to the
 \link{colData} slot. Additionally, the
decontaminated counts will be added as an assay called 'decontXCounts'.
}
\description{
A wrapper function for \link[scater]{isOutlier}. Identify
 outliers from numeric vectors stored in the SingleCellExperiment object.
}
\examples{
data(scExample, package = "singleCellTK")
sce <- subsetSCECols(sce, colData = "type != 'EmptyDroplet'")
sce <- runDecontX(sce[,sample(ncol(sce),20)])
sce <- detectCellOutlier(sce, slotName = "colData", sample = sce$sample,
 nmads = 4, itemName = "decontX_contamination", type = "both")
}
