% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorder.R
\name{dag_reorder}
\alias{dag_reorder}
\alias{dag_permutate_children}
\title{Reorder the DAG}
\usage{
dag_reorder(dag, value, verbose = simona_opt$verbose)

dag_permutate_children(dag, verbose = simona_opt$verbose)
}
\arguments{
\item{dag}{An \code{ontology_Dag} object.}

\item{value}{A vector of numeric values. See the \strong{Details} section.}

\item{verbose}{Whether to print messages.}
}
\value{
An \code{ontology_DAG} object.
}
\description{
Reorder the DAG
}
\details{
In \code{dag_reorder()}, there are two ways to set the \code{value} argument. It can be a vector corresponding
to all terms (in the same order as in \code{\link[=dag_all_terms]{dag_all_terms()}}) or a vector corresponding
to all leaf terms (in the same order as in \code{\link[=dag_leaves]{dag_leaves()}}). If \code{value} corresponds
to all terms, the score associates to each term is the average value of all its offspring terms.
And if \code{value} corresponds to all leaf terms, the score for each term is the average of all its
connectable leaves.

The reordering is simply applied on each term to reorder its child terms.

\code{dag_permutate_children()} randomly permute child terms under a term.
}
\examples{
parents  = c("a", "a", "b", "b", "c", "d")
children = c("b", "c", "c", "d", "e", "f")
# by default, c and e locate on the left side, d and f locate on the right side
dag = create_ontology_DAG(parents, children)
dag_children(dag, "b")

# move c and e to the right side of the diagram
dag2 = dag_reorder(dag, value = c(1, 1, 10, 1, 10, 1))
dag_children(dag2, "b")

# we can also only set values for leaf terms
# there are two leaf terms c and e
# we let v(c) > v(e) to move c to the right side of the diagram
dag3 = dag_reorder(dag, value = c(10, 1))
dag_children(dag3, "b")
}
