% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/go.R
\name{create_ontology_DAG_from_GO_db}
\alias{create_ontology_DAG_from_GO_db}
\alias{alternative_GO_terms}
\title{Create the ontology_DAG object from the GO.db package}
\usage{
create_ontology_DAG_from_GO_db(
  namespace = "BP",
  relations = "part of",
  org_db = NULL,
  evidence_code = NULL,
  retrieve_alternative = FALSE,
  verbose = simona_opt$verbose
)

alternative_GO_terms(
  tag = c("replaced_by", "alt_id", "consider"),
  version = NULL,
  verbose = TRUE
)
}
\arguments{
\item{namespace}{One of "BP", "CC" and "MF".}

\item{relations}{Types of the GO term relations. In the \strong{GO.db} package, the GO term relations can be "is_a", "part_of",
"regulates", "negatively regulates", "positively regulates". Note since "regulates" is a parent relation
of "negatively regulates", "positively regulates", if "regulates" is selected, "negatively regulates" and "positively regulates"
are also selected. Note "is_a" is always included.}

\item{org_db}{The name of the organism package or the corresponding database object, e.g. \code{"org.Hs.eg.db"} or
directly the \code{\link[org.Hs.eg.db:org.Hs.egBASE]{org.Hs.eg.db::org.Hs.eg.db}} object for human, then the gene annotation to GO terms will be added
to the object. For other non-model organisms, consider to use the \strong{AnnotationHub} package to find one.}

\item{evidence_code}{A vector of evidence codes for gene annotation to GO terms. See \url{https://geneontology.org/docs/guide-go-evidence-codes/}.}

\item{retrieve_alternative}{Whether to retrieve alternative/obsolete GO terms from geneontology.org?}

\item{verbose}{Whether to print messages.}

\item{tag}{In the \code{go-basic.obo} file, there are three tags which define alternative GO terms: \code{replaced_by}, \code{alt_id} and \code{consider}.
See https://owlcollab.github.io/oboformat/doc/GO.format.obo-1_4.html#S.2.2.1}

\item{version}{Version of the \code{go-basic.obo} file. By default it is the version for building \strong{GO.db} package. The value is a string in the format of "2024-01-17".}
}
\value{
An \code{ontology_DAG} object.

A list of named vectors where names are alternative GO IDs and value vectors are current GO IDs in use.
}
\description{
Create the ontology_DAG object from the GO.db package

Mappings between alternative GO terms to official GO terms
}
\examples{
dag = create_ontology_DAG_from_GO_db()
dag
}
