% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{set_readable}
\alias{set_readable}
\title{Set Readable}
\usage{
set_readable(
  tb,
  OrgDb = "org.Hs.eg.db",
  keyType = "ENTREZID",
  geneCol = "itemID"
)
}
\arguments{
\item{tb}{tibble object, enrichment result table}

\item{OrgDb}{character(1), 'org.Hs.eg.db' for human}

\item{keyType}{character(1), keyType of gene}

\item{geneCol}{character(1), name of the column in 'tb' containing gene
Entrez ids separated by '/' to be converted to gene Symbol}
}
\value{
tibble Object
}
\description{
Mapping 'itemID' column in the FEA enrichment result table from Entrez ID
to gene Symbol
}
\examples{
data(drugs10)
res <- tsea_dup_hyperG(drugs=drugs10, type="Reactome", pvalueCutoff=1, 
                       qvalueCutoff=1)
res_tb <- set_readable(result(res))
}
