% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moa_conn.R
\name{moa_conn}
\alias{moa_conn}
\title{Summarize GESS Results on MOA Level}
\usage{
moa_conn(gess_tb, moa_cats = "default", cells = "normal")
}
\arguments{
\item{gess_tb}{tibble in \code{\link{gessResult}} object}

\item{moa_cats}{if set as "default", it uses MOA annotations from the CLUE 
website (https://clue.io). 
Users can customize it by providing a `list` of character vectors containing
drug names and MOA categories as list component names.}

\item{cells}{one of "normal", "cancer" or "all", or a character vector 
containing cell types of interest.
\itemize{
  \item "all": all cell types in LINCS database;
  \item "normal": normal cell types in LINCS database as one group; 
  \item "tumor": tumor cell types in LINCS database as one group;
}}
}
\value{
data.frame
}
\description{
Function summarizes GESS results on Mode of Action (MOA) level.
It returns a tabular representation of MOA 
categories ranked by their average signature search similarity to a query
signature.
}
\details{
Column description of the result table:

moa: Mechanism of Action (MOA)

cells: cell type information

mean_rank: mean rank of drugs in corresponding GESS result for each MOA 
category

n_drug: number of drugs in each MOA category
}
\examples{
res_moa <- moa_conn(dplyr::tibble(
                    pert=c("vorinostat", "trichostatin-a", "HC-toxin"), 
                    cell=rep("SKB",3), 
                    pval=c(0.001,0.02,0.05)))
}
\seealso{
\code{\link{gessResult}}
}
