% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{meanExpr2h5}
\alias{meanExpr2h5}
\title{Calculate Mean Expression Values of LINCS Level 3 Data}
\usage{
meanExpr2h5(gctx, inst, h5file, chunksize = 2000, overwrite = TRUE)
}
\arguments{
\item{gctx}{character(1), path to the LINCS Level 3 gctx file}

\item{inst}{tibble, LINCS Level 3 instances after filtering for specific concentrations and times}

\item{h5file}{character(1), path to the destination HDF5 file}

\item{chunksize}{number of columns of the matrix to be processed at a time to limit memory usage}

\item{overwrite}{TRUE or FALSE, whether to overwrite or append data to an
existing 'h5file'}
}
\value{
HDF5 file, representing the \code{lincs_expr} database
}
\description{
Function calculates mean expression values for replicated samples of LINCS
Level 3 data that have been treated by the same compound in the same cell type
at a chosen concentration and treatment time. Usually, the function is used
after filtering the Level 3 data with \code{inst_filter}. The results (here
matrix with mean expression values) are saved to an HDF5 file. The latter is
referred to as the `lincs_expr` database.
}
\examples{
gctx <- system.file("extdata", "test_sample_n2x12328.gctx", package="signatureSearch")
h5file <- tempfile(fileext=".h5")
inst <- data.frame(inst_id=c("ASG001_MCF7_24H:BRD-A79768653-001-01-3:10",
                             "CPC012_SKB_24H:BRD-K81418486:10"), 
    pert_cell_factor=c('sirolimus__MCF7__trt_cp', 'vorinostat__SKB__trt_cp'))
meanExpr2h5(gctx, inst, h5file, overwrite=TRUE)
}
