% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gseAnalyzer2.R
\name{gseReactome}
\alias{gseReactome}
\title{Modified GSEA with Reactome}
\usage{
gseReactome(
  geneList,
  organism = "human",
  exponent = 1,
  nPerm = 1000,
  minGSSize = 10,
  maxGSSize = 500,
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  verbose = TRUE,
  readable = FALSE
)
}
\arguments{
\item{geneList}{order ranked geneList}

\item{organism}{one of "human", "rat", "mouse", "celegans", "yeast", 
"zebrafish", "fly".}

\item{exponent}{integer value used as exponent in GSEA algorithm.}

\item{nPerm}{integer defining the number of permutation iterations for 
calculating p-values}

\item{minGSSize}{minimal size of each geneSet for analyzing}

\item{maxGSSize}{maximal size of each geneSet for analyzing}

\item{pvalueCutoff}{pvalue Cutoff}

\item{pAdjustMethod}{pvalue adjustment method}

\item{verbose}{print message or not
TRUE or FALSE indicating whether to convert gene Entrez ids
to gene Symbols in the 'itemID' column in the FEA result table.}

\item{readable}{TRUE or FALSE indicating whether to convert gene Entrez ids
to gene Symbols in the 'itemID' column in the FEA result table.}
}
\value{
feaResult object
}
\description{
This modified Gene Set Enrichment Analysis (GSEA) of Reactome pathways
supports gene test sets with large numbers of zeros.
}
\examples{
# Gene Entrez id should be used for Reactome enrichment
data(geneList, package="DOSE")
#geneList[100:length(geneList)]=0
#rc <- gseReactome(geneList=geneList, pvalueCutoff=1)
}
