% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gseAnalyzer2.R
\name{gseGO2}
\alias{gseGO2}
\title{Modified GSEA with GO Terms}
\usage{
gseGO2(
  geneList,
  ont = "BP",
  OrgDb,
  keyType = "SYMBOL",
  exponent = 1,
  nproc = 1,
  nPerm = 1000,
  minGSSize = 2,
  maxGSSize = 500,
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  verbose = TRUE
)
}
\arguments{
\item{geneList}{named numeric vector with gene SYMBOLs in the name slot
decreasingly ranked by scores in the data slot.}

\item{ont}{one of "BP", "MF", "CC" or "ALL"}

\item{OrgDb}{OrgDb, e.g., "org.Hs.eg.db".}

\item{keyType}{keytype of gene}

\item{exponent}{weight of each step}

\item{nproc}{if not equal to zero, sets \code{BPPARAM} to use \code{nproc} 
workers (default = 1)}

\item{nPerm}{permutation numbers}

\item{minGSSize}{integer, minimum size of each gene set in annotation system}

\item{maxGSSize}{integer, maximum size of each gene set in annotation system}

\item{pvalueCutoff}{pvalue cutoff}

\item{pAdjustMethod}{pvalue adjustment method}

\item{verbose}{print message or not}
}
\value{
feaResult object
}
\description{
This modified Gene Set Enrichment Analysis (GSEA) of GO terms supports
gene test sets with large numbers of zeros.
}
\examples{
data(targetList)
# gsego <- gseGO2(geneList=targetList, ont="MF", OrgDb="org.Hs.eg.db",
#                 pvalueCutoff=1)
# head(gsego)
}
