% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oraAnalyzer.R
\name{enrichMOA}
\alias{enrichMOA}
\title{MOA Category Enrichment with Hypergeometric Test}
\usage{
enrichMOA(gene, pvalueCutoff = 0.05, pAdjustMethod = "BH", qvalueCutoff = 0.2)
}
\arguments{
\item{gene}{a vector of entrez gene ids (here the test set)}

\item{pvalueCutoff}{pvalue cutoff}

\item{pAdjustMethod}{one of "holm", "hochberg", "hommel", 
"bonferroni", "BH", "BY", "fdr", "none"}

\item{qvalueCutoff}{qvalue cutoff}
}
\value{
A \code{feaResult} instance.
}
\description{
Given a vector of gene identifiers, this function returns MOA category 
enrichment results based on a hypergeometric test with duplication support 
in the test set. The universe for the test is set to the unique genes 
encoding the target proteins present in the MOA annotation system from the 
ChEMBL database.
}
\examples{
data(geneList, package="DOSE")
emoa <- enrichMOA(gene = names(geneList)[seq(3)])
head(emoa)
}
\seealso{
\code{\link{feaResult-class}}
}
