% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oraAnalyzer.R
\name{enrichGO2}
\alias{enrichGO2}
\title{GO Term Enrichment with Hypergeometric Test}
\usage{
enrichGO2(
  gene,
  OrgDb,
  keytype = "SYMBOL",
  ont = "MF",
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  universe,
  qvalueCutoff = 0.2,
  minGSSize = 5,
  maxGSSize = 500,
  pool = FALSE
)
}
\arguments{
\item{gene}{a vector of gene SYMBOL ids (here the test set)}

\item{OrgDb}{OrgDb}

\item{keytype}{Gene ID type of test set}

\item{ont}{One of "MF", "BP", "CC" or "ALL"}

\item{pvalueCutoff}{pvalue cutoff}

\item{pAdjustMethod}{one of "holm", "hochberg", "hommel", 
"bonferroni", "BH", "BY", "fdr", "none"}

\item{universe}{background genes}

\item{qvalueCutoff}{qvalue cutoff}

\item{minGSSize}{minimum size of each gene set in annotation system}

\item{maxGSSize}{maximum size of each gene set in annotation system}

\item{pool}{If ont='ALL', whether 3 GO ontology should be combined}
}
\value{
A \code{feaResult} instance.
}
\description{
Given a vector of gene identifiers, this function returns GO term enrichment
results based on a hypergeometric test with duplication support in the test 
set.
}
\examples{
# The method supports duplicated elements in 'gene', 
# which should be gene SYMBOL ids for GO term enrichment.
gene <- c(rep("HDAC1",4), rep("HDAC3",2), "SOX8", "KLK14")
# data(targetList)
# ego <- enrichGO2(gene = gene, OrgDb="org.Hs.eg.db", ont="MF",
#                  universe=names(targetList))
}
\seealso{
\code{\link{feaResult-class}}
}
