% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{create_empty_h5}
\alias{create_empty_h5}
\title{Create Empty HDF5 File}
\usage{
create_empty_h5(h5file, delete_existing = FALSE, level = 6)
}
\arguments{
\item{h5file}{character(1), path to the HDF5 file to be created}

\item{delete_existing}{logical, whether to delete an existing HDF5 file with 
identical path}

\item{level}{The compression level used, here given as integer value between 
0 (no compression) and 9 (highest and slowest compression).}
}
\value{
empty HDF5 file
}
\description{
This function can be used to create an empty HDF5 file where the user defines
the file path and compression level. The empty HDF5 file has under its root
group three data slots named 'assay', 'colnames' and 'rownames' for storing a
\code{numeric matrix} along with its column names (\code{character}) and row 
names (\code{character}), respectively.
}
\examples{
tmp_file <- tempfile(fileext=".h5")
create_empty_h5(tmp_file, level=6)
}
