% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-flow.R
\docType{methods}
\name{link_what}
\alias{link_what}
\alias{link_what,Tool,Tool-method}
\alias{link_what,Tool,SBGWorkflow-method}
\alias{link_what,SBGWorkflow,Tool-method}
\alias{link_what,SBGWorkflow,SBGWorkflow-method}
\title{List possible linking methods}
\usage{
link_what(from, to, ...)

\S4method{link_what}{Tool,Tool}(from, to)

\S4method{link_what}{Tool,SBGWorkflow}(from, to)

\S4method{link_what}{SBGWorkflow,Tool}(from, to)

\S4method{link_what}{SBGWorkflow,SBGWorkflow}(from, to)
}
\arguments{
\item{from}{either Tool App or SBGWorkflow object}

\item{to}{either Tool App or Workflow object}

\item{...}{more auguments}
}
\value{
A Workflow object
}
\description{
List possible linking methods
}
\details{
Given two object of Tool, Flow or App, list all possible input/output match.
}
\examples{
t1 <- system.file("extdata/app", "tool_unpack_fastq.json", package = "sevenbridges")
t2 <- system.file("extdata/app", "tool_star.json", package = "sevenbridges")
t1 <- convert_app(t1)
t2 <- convert_app(t2)
# check possible link
link_what(t1, t2)
tool.in <- system.file("extdata/app", "tool_unpack_fastq.json", package = "sevenbridges")
flow.in <- system.file("extdata/app", "flow_star.json", package = "sevenbridges")
t1 <- convert_app(tool.in)
f2 <- convert_app(flow.in)
link_what(t1, f2)
tool.in <- system.file("extdata/app", "tool_unpack_fastq.json", package = "sevenbridges")
flow.in <- system.file("extdata/app", "flow_star.json", package = "sevenbridges")
t1 <- convert_app(tool.in)
f2 <- convert_app(flow.in)
link_what(f2, t1)
}
