% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction.R
\name{addInteractionSupport}
\alias{addInteractionSupport}
\title{Add column to \code{\link{GInteractions}} with overlap support.}
\usage{
addInteractionSupport(gi, subject, colname = "loop", ...)
}
\arguments{
\item{gi}{\code{\link{GInteractions}} object}

\item{subject}{another \code{\link{GInteractions}} object}

\item{colname}{name of the new annotation column in \code{gi}.}

\item{...}{additional arguments passed to \code{\link[IRanges:findOverlaps-methods]{overlapsAny}}.}
}
\value{
\code{\link{InteractionSet}} \code{gi} as input but with additional
  annotation column \code{colname} indicating whether each interaction
  is supported by \code{subject} or not.
}
\description{
See overlap methods in \code{\link{InteractionSet}} package for more details
on the overlap calculations: \code{?overlapsAny}
}
\examples{

# build example GRanges as anchors
anchorGR <- GRanges(
 rep("chr1", 4),
 IRanges(
   c(1, 5, 20, 14),
   c(4, 8, 23, 17)
 ),
 strand = c("+", "+", "+", "-"),
 score = c(5, 4, 6, 7)
)


# build example GIntreaction object
gi <- GInteractions(
 c(1, 2, 2),
 c(4, 3, 4),
 anchorGR,
 mode = "strict"
)

# build exapple support GInteractions object
exampleSupport <- GInteractions(
    GRanges("chr1", IRanges(1, 4)),
    GRanges("chr1", IRanges(15, 20))
)

# add support
gi <- addInteractionSupport(gi, subject = exampleSupport)

# Use colname argument to add support to differnt metadata column name
gi <- addInteractionSupport(gi, subject = exampleSupport, colname = "example")

}
