% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sex.R
\name{inferSex}
\alias{inferSex}
\title{Infer sex.}
\usage{
inferSex(betas, platform = NULL)
}
\arguments{
\item{betas}{DNA methylation beta}

\item{platform}{EPICv2, EPIC, HM450, MM285, etc.}
}
\value{
Inferred sex of sample
}
\description{
We established our sex calling based on the CpGs hypermethylated in
inactive X (XiH), CpGs hypomethylated in inactive X (XiL).
}
\details{
Note genotype abnormalities such as Dnmt genotype,
XXY male (Klinefelter's),
45,X female (Turner's) can confuse the model sometimes.
This function works on a single sample.
}
\examples{

## EPICv2 input
betas = openSesame(sesameDataGet("EPICv2.8.SigDF")[[1]])
inferSex(betas)

\dontrun{
## MM285 input
betas = openSesame(sesameDataGet("MM285.1.SigDF"))
inferSex(betas)

## EPIC input
betas = openSesame(sesameDataGet('EPIC.1.SigDF'))
inferSex(betas)

## HM450 input
betas = openSesame(sesameDataGet("HM450.10.SigDF")[[1]])
inferSex(betas)
}

}
