% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_signal_plots.R
\name{ssvSignalLineplot}
\alias{ssvSignalLineplot}
\title{construct line type plots where each region in each sample is represented}
\usage{
ssvSignalLineplot(
  bw_data,
  x_ = "x",
  y_ = "y",
  color_ = "sample",
  sample_ = "sample",
  region_ = "id",
  group_ = "auto_grp",
  line_alpha = 1,
  facet_ = "auto_facet",
  facet_method = facet_wrap,
  spline_n = NULL,
  return_data = FALSE
)
}
\arguments{
\item{bw_data}{a GRanges or data.table of bigwig signal.
As returned from \code{\link{ssvFetchBam}} and \code{\link{ssvFetchBigwig}}}

\item{x_}{variable name mapped to x aesthetic, x by default.}

\item{y_}{variable name mapped to y aesthetic, y by default.}

\item{color_}{variable name mapped to color aesthetic, sample by default.}

\item{sample_}{variable name, along with region_ used to group and
facet by default, change group_ or facet_ to override.}

\item{region_}{variable name, along with sample_ used to group and facet
by default, change group_ or facet_ to override.}

\item{group_}{group aesthetic keeps lines of geom_path from mis-connecting.
auto_grp by default which combines sample_ and region_.
probably shouldn't change.}

\item{line_alpha}{alpha value for lines. default is 1.}

\item{facet_}{facetting divides up plots.
auto_facet by default which combines sample_ and region_.
if overriding facet_method with facet_grid, make sure to include ~ between
two variables, ie. "a~b", ".~b", "a~."}

\item{facet_method}{ggplot2 facetting method or wrapper for same,
facet_wrap by default.}

\item{spline_n}{if not NULL, applySpline will be called with n = spline_n.
default is NULL.}

\item{return_data}{logical.  If TRUE, return value is no longer ggplot and
is instead the data used to generate that plot. Default is FALSE.}
}
\value{
ggplot of signal potentially facetted by region and sample
}
\description{
construct line type plots where each region in each sample is represented
}
\examples{
data(CTCF_in_10a_profiles_gr)

bw_gr = CTCF_in_10a_profiles_gr
ssvSignalLineplot(subset(bw_gr, bw_gr$id \%in\% seq_len(3)), facet_ = "sample")
ssvSignalLineplot(subset(bw_gr, bw_gr$id \%in\% seq_len(3)),
    facet_ = "sample~.",
    facet_method = facet_grid)
ssvSignalLineplot(subset(bw_gr, bw_gr$id \%in\% seq_len(3)),
    facet_ = paste("sample", "~", "id"), facet_method = facet_grid)
ssvSignalLineplot(subset(bw_gr, bw_gr$id \%in\% seq_len(3)))
ssvSignalLineplot(subset(bw_gr, bw_gr$id \%in\% seq_len(3)), facet_ = "id")
ssvSignalLineplot(subset(bw_gr, bw_gr$id \%in\% seq_len(3)),
    facet_ = "id", spline_n = 10)
}
