% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_feature_plots.R
\name{ssvFeatureBinaryHeatmap}
\alias{ssvFeatureBinaryHeatmap}
\title{ssvFeatureBinaryHeatmap}
\usage{
ssvFeatureBinaryHeatmap(
  object,
  raster_approximation = TRUE,
  true_color = "black",
  false_color = "#EFEFEF",
  raster_width_min = 1000,
  raster_height_min = 1000,
  return_data = FALSE
)
}
\arguments{
\item{object}{passed to ssvMakeMembTable}

\item{raster_approximation}{If TRUE, instead of standard ggplot, write
temporary raster png image and redraw that as plot background. default is
FALSE}

\item{true_color}{character. rcolor or hex color used for TRUE values.
default is "black".}

\item{false_color}{character. rcolor or hex color used for TRUE values.
default is "#EFEFEF", a gray.}

\item{raster_width_min}{raster width will be minimum multiple of number of
columns over this number.  ignored if raster_approximation is FALSE.}

\item{raster_height_min}{raster height will be minimum multiple of number of
rows over this number  ignored if raster_approximation is FALSE}

\item{return_data}{logical.  If TRUE, return value is no longer ggplot and
is instead the data used to generate that plot. Default is TRUE}
}
\value{
ggplot using geom_tile of membership table sorted from left to right.
}
\description{
Outputs a ggplot binary heatmap, where color indicates TRUE and the other
indicates FALSE in a membership table. The heatmap is sorted, TRUE at the
top, by column left to right. Changes to column order can reveal different
patterns.
}
\details{
As a svg output, the final plot can be unwieldy. The default of
\code{raster_approximation} = TRUE is easier to work with, especially for larger
membership tables.
}
\examples{
data(CTCF_in_10a_overlaps_gr)
ssvFeatureBinaryHeatmap(list(1:3, 2:6))
# horizontal version
ssvFeatureBinaryHeatmap(list(1:3, 2:6)) + coord_flip() +
  theme(axis.text.x = element_blank(), axis.text.y = element_text())
ssvFeatureBinaryHeatmap(CTCF_in_10a_overlaps_gr)
ssvFeatureBinaryHeatmap(S4Vectors::mcols(CTCF_in_10a_overlaps_gr)[,2:3])
ssvFeatureBinaryHeatmap(S4Vectors::mcols(CTCF_in_10a_overlaps_gr)[,3:2])
}
