% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_fetch_bam.R
\name{getReadLength}
\alias{getReadLength}
\title{determine the most common read length for input bam_file.  uses 50 randomly
selected regions from query_gr.  If fewer than 20 reads are present, loads
all of query_gr.}
\usage{
getReadLength(bam_file, query_gr)
}
\arguments{
\item{bam_file}{indexed bam file}

\item{query_gr}{GRanges to read from bam file}
}
\value{
numeric of most common read length.
}
\description{
determine the most common read length for input bam_file.  uses 50 randomly
selected regions from query_gr.  If fewer than 20 reads are present, loads
all of query_gr.
}
\examples{
data(CTCF_in_10a_overlaps_gr)
qgr = CTCF_in_10a_overlaps_gr[1:5]
bam_file = system.file("extdata/test.bam", package = "seqsetvis", mustWork = TRUE)
getReadLength(bam_file, qgr)
}
